# WannaBeeモジュール Z240-MP4/CP13 サンプルコード（HEXコマンド）

このサンプルコードは、Z240-MP4/CP13を使用したZigBee®通信の動作サンプルです。

## ファイル構成
```
hex_command/
  ├─transmission_example/  # 透過伝送機能サンプル
  │      coordinator.py          # コーディネータ設定
  │      end_device.py           # エンドデバイス（非スリープ型）設定
  │      reset.py                # 設定の初期化
  │      router.py               # ルータ設定
  │      sleepy_end_device.py    # エンドデバイス（スリープ型）設定
  │
  └─zcl_example/  # ZCLデバイス機能サンプル
      ├─coordinator/  # コーディネータ動作スクリプト
      │      config.py           # コーディネータ設定
      │      device_class.py     # クラス定義
      │      reset.py            # 設定の初期化
      │      run.py              # 動作実行
      │
      └─end_device/  # エンドデバイス動作スクリプト
          │  reset.py            # 設定の初期化
          │
          ├─on_off_light/  # ON/OFFライト
          │      config.py       # ZCLエンドポイントの設定
          │      run.py          # 動作実行
          │
          └─temperature_sensor/  # 温度センサー
                  config.py      # ZCLエンドポイントの設定
                  run.py         # 動作実行
```

## 動作環境
- Python: 3.9 以上

## 実行方法
1. Z240-MP4またはZ240-CP13をPCに接続します。
2. シリアルポート名を確認します（例：Windowsでは COM1、Linux/macOSでは /dev/ttyUSB0 など）。
3. シリアルポート名を指定してスクリプトを実行します。
```bash
python reset.py COM1
```
## 実行例
### transmission_example
透過伝送機能のサンプルコードです。Z240-MP4またはZ240-CP13を2つ使用します。

1. reset.py で設定を初期化します。
2. 一方のモジュールで coordinator.py を実行します。
3. もう一方のモジュールで end_device.py または sleepy_end_device.py を実行します。

エンドデバイス側のモジュールに書き込んだデータがコーディネータ側に伝送されます。

### zcl_example
ZCLデバイス機能のサンプルコードです。  
end_device は、Z240-MP4をエンドデバイスとして設定し動作するサンプルです。
1. reset.py で設定を初期化します
2. config.py を実行します
3. コーディネータ（ZigBee®ゲートウェイ／ハブ）側で管理デバイスの追加操作を行います
4. run.py を実行します

coordinator は、Z240-MP4またはZ240-CP13をコーディネータとして設定し動作するサンプルです。
1. reset.py で設定を初期化します
2. config.py を実行します
3. エンドデバイス側でネットワーク参加の操作を行います
4. run.py を実行します

## ライセンス
このコードは MIT ライセンスのもとで公開されています。