# WannaBeeモジュール Z240-CP13 サンプルコード（ATコマンド）

このサンプルコードは、Z240-CP13を使用したZigBee®通信の動作サンプルです。

## ファイル構成
```
at_command/
  └─transmission_example/  # 透過伝送機能サンプル
          coordinator.py        # コーディネータ設定
          end_device.py         # エンドデバイス（非スリープ型）設定
          reset.py              # 設定の初期化
          router.py             # ルータ設定
          sleepy_end_device.py  # エンドデバイス（スリープ型）設定
```

## 動作環境
- Python: 3.9 以上

## 実行方法
1. Z240-MP4またはZ240-CP13をPCに接続します
2. シリアルポート名を確認します（例：Windowsでは COM1、Linux/macOSでは /dev/ttyUSB0 など）
3. シリアルポート名を指定してスクリプトを実行します
```bash
python reset.py COM1
```

## 実行例
### transmission_example
透過伝送機能のサンプルコードです。Z240-MP4またはZ240-CP13を2つ使用します。

1. reset.py で設定を初期化します
2. 一方のモジュールで coordinator.py を実行します
3. もう一方のモジュールで、 end_device.py または sleepy_end_device.py を実行します

エンドデバイス側のモジュールに書き込んだデータがコーディネータ側に伝送されます。

## ライセンス
このコードは MIT ライセンスのもとで公開されています。
